<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->String('app_name');
            $table->String('authorization')->nullable();
            $table->String('tmdb_api_key')->nullable();
            $table->String('purchase_key')->nullable();
            $table->longText('tmdb_lang');
            $table->String('app_url_android')->nullable();
            $table->boolean('autosubstitles');
            $table->boolean('livetv');
            $table->boolean('ads_player');
            $table->boolean('anime');
            $table->integer('facebook_show_interstitial');
            $table->integer('ad_show_interstitial');
            $table->boolean('ad_interstitial');
            $table->String('ad_unit_id_interstitial')->nullable();
            $table->boolean('ad_banner');
            $table->String('ad_unit_id_banner')->nullable();
            $table->boolean('ad_face_audience_interstitial');
            $table->boolean('ad_face_audience_banner');
            $table->String('ad_unit_id_facebook_interstitial_audience')->nullable();
            $table->String('ad_unit_id_facebook_banner_audience')->nullable();
            $table->longText('privacy_policy')->nullable();
            $table->String('latestVersion')->nullable();
            $table->String('update_title')->nullable();
            $table->longText('releaseNotes')->nullable();
            $table->integer('enable_custom_message');
            $table->longText('custom_message')->nullable();
            $table->String('url')->nullable();
            $table->String('imdb_cover_path')->nullable();
            $table->String('paypal_client_id')->nullable();
            $table->String('paypal_amount')->nullable();
            $table->String('stripe_publishable_key')->nullable();
            $table->String('stripe_secret_key')->nullable();
            $table->integer('featured_home_numbers');
            $table->String('startapp_id')->nullable();
            $table->String('ad_unit_id_rewarded')->nullable();
            $table->String('ad_unit_id__facebook_rewarded')->nullable();
            $table->String('ad_unit_id__appodeal_rewarded')->nullable();
            $table->String('unity_game_id')->nullable();
            $table->String('default_network')->nullable();
            $table->integer('wach_ads_to_unlock');
            $table->boolean('aws_s3_storage')->default(0);
            $table->String('aws_access_key_id')->nullable();
            $table->String('aws_secret_access_key')->nullable();
            $table->String('aws_default_region')->nullable();
            $table->String('aws_bucket')->nullable();
            $table->boolean('wasabi_storage')->default(0);
            $table->String('wasabi_access_key_id')->nullable();
            $table->String('wasabi_secret_access_key')->nullable();
            $table->String('wasabi_default_region')->nullable();
            $table->String('wasabi_bucket')->nullable();
            $table->String('default_media_placeholder_path')->nullable();
            $table->integer('next_episode_timer');
            $table->String('facebook_url')->nullable();
            $table->String('twitter_url')->nullable();
            $table->String('instagram_url')->nullable();
            $table->String('telegram_url')->nullable();
            $table->String('ad_unit_id_native')->nullable();
            $table->String('default_payment')->nullable();
            $table->String('paypal_currency')->nullable();
            $table->integer('appodeal_show_interstitial');
            $table->integer('ad_unit_id_native_enable');
            $table->integer('appodeal_banner');
            $table->integer('appodeal_interstitial');
            $table->integer('server_dialog_selection');
            $table->integer('download_premuim_only')->default(0);
            $table->String('default_network_player')->nullable();
            $table->integer('wach_ads_to_unlock_player')->default(0);
            $table->integer('enable_custom_banner')->default(0);
            $table->String('custom_banner_image')->nullable();
            $table->String('custom_banner_image_link')->nullable();
            $table->String('default_downloads_options')->nullable();
            $table->text('mantenance_mode_message')->nullable();
            $table->String('splash_image')->nullable();
            $table->String('default_youtube_quality')->nullable();
            $table->integer('mantenance_mode')->default(0);
            $table->integer('allow_adm')->default(0);
            $table->integer('enable_previews')->default(0);
            $table->integer('enable_pinned')->default(0);
            $table->integer('startapp_banner')->default(0);
            $table->integer('startapp_interstitial')->default(0);
            $table->integer('enable_vlc')->default(0);
            $table->integer('resume_offline')->default(1);
            $table->String('user_agent')->nullable();
            $table->integer('unityads_banner')->default(0);
            $table->integer('unityads_interstitial')->default(0);
            $table->integer('streaming')->default(1);
            $table->integer('enable_banner_bottom')->default(0);
            $table->integer('ad_face_audience_native')->default(0);
            $table->integer('enable_upcoming')->default(1);
            $table->String('ad_unit_id_facebook_native_audience')->nullable();
            $table->String('app_packagename')->nullable();
            $table->boolean('enable_download')->default(1);
            $table->boolean('notification_separated')->default(0);
            $table->String('default_cast_option')->nullable()->default("INTERNAL");
            $table->String('default_trailer_default')->nullable()->default("Youtube");
            $table->String('hxfile_api_key')->nullable();
            $table->boolean('email_verify')->default(0);
            $table->boolean('force_login')->default(0);
            $table->boolean('favoriteonline')->default(1);
            $table->boolean('separate_download')->default(0);
            $table->boolean('vpn')->default(0);
            $table->boolean('notification_style')->default(0);
            $table->boolean('force_update')->default(0);
            $table->boolean('appnext_banner')->default(0);
            $table->boolean('appnext_interstitial')->default(0);
            $table->String('appnext_placementid')->nullable();
            $table->boolean('livetv_multi_servers')->default(0);
            $table->boolean('suggest_auth')->default(0);
            $table->boolean('networks')->default(0);
            $table->boolean('enable_webview')->default(0);
            $table->String('webview_link')->nullable();
            $table->boolean('vungle_banner')->default(0);
            $table->boolean('vungle_interstitial')->default(0);
            $table->String('vungle_appid')->nullable();
            $table->String('vungle_interstitial_placement_name')->nullable();
            $table->String('vungle_banner_placement_name')->nullable();
            $table->String('vungle_reward_placement_name')->nullable();
            $table->boolean('flag_secure')->default(0);
            $table->integer('appnext_interstitial_show');
            $table->boolean('ironsource_banner')->default(0);
            $table->boolean('ironsource_interstitial')->default(0);
            $table->String('ironsource_app_key')->nullable();
            $table->String('ironsource_interstitial_placement_name')->nullable();
            $table->String('ironsource_banner_placement_name')->nullable();
            $table->String('ironsource_reward_placement_name')->nullable();
            $table->integer('unity_show')->default(0);
            $table->boolean('root_detection')->default(0);
            $table->boolean('applovin_banner')->default(0);
            $table->boolean('applovin_interstitial')->default(0);
            $table->String('applovin_banner_unitid')->nullable();
            $table->String('applovin_interstitial_unitid')->nullable();
            $table->String('applovin_reward_unitid')->nullable();
            $table->integer('applovin_interstitial_show')->default(0);
            $table->integer('vungle_interstitial_show')->default(0);
            $table->integer('ironsource_interstitial_show')->default(0);
            $table->String('unity_banner_placement_id')->nullable()->default("banner");
            $table->String('unity_interstitial_placement_id')->nullable()->default("inter");
            $table->String('unity_reward_placement_id')->nullable()->default("rewardedVideo");
            $table->String('reset_password_message')
            ->nullable()->default("message");
            $table->boolean('force_password_access')->default(0);
            $table->boolean('force_inappupdate')->default(0);
            $table->String('password')->nullable();
            $table->String('default_layout_networks')->nullable()->default("Layout1");
            $table->String('default_substitle_option')->nullable()->default("Opensubs");
            $table->boolean('enable_comments')->default(0);
            $table->boolean('applovin_native')->default(0);
            $table->String('applovin_native_unitid')->nullable();
            $table->String('discover_style')->nullable();
            $table->String('library_style')->nullable();
            $table->String('webpanelversion')->nullable()->default("2.1");
            $table->boolean('phone_verification')->default(0);
            $table->boolean('profile_selection')->default(0);
            $table->boolean('trustAllCerts')->default(0);
            $table->boolean('device_management')->default(0);
            $table->boolean('enable_player_inter')->default(0);
            $table->boolean('internallangs')->default(0);
            $table->boolean('searchhistory')->default(0);
            $table->boolean('forcewatchbyauth')->default(0);
            $table->boolean('safemode')->default(0);
            $table->boolean('enable_watchinyourlang')->default(0);
            $table->boolean('wortise_interstitial')->default(0);
            $table->boolean('wortise_banner')->default(0);
            $table->String('wortise_appid')->nullable();
            $table->String('wortise_placement_unitid')->nullable();
            $table->boolean('wortise_interstitial_show')->default(0);
            $table->boolean('wortise_banner_enable')->default(0);
            $table->String('wortise_banner_unitid')->nullable();
            $table->String('wortise_reward_unitid')->nullable();
            $table->boolean('enablelangsinservers')->default(0);
            $table->boolean('enablesociallogins')->default(0);
            $table->boolean('enabledynamicslider')->default(0);
            $table->integer('slidertimer')->default(5);
            $table->integer('device_management_limit')->default(5);
            $table->integer('profile_selection_limit')->default(5);
            $table->boolean('enablelayoutchange')->default(0);
            $table->boolean('enableshadow')->default(1);
            $table->boolean('enablecustomcontent')->default(0);
            $table->json('rv_content')->nullable();
            $table->json('rv_content_network')->nullable();
            $table->json('rv_content_lang')->nullable();
            $table->boolean('disablelogin')->default(0);
            $table->boolean('vidsrc')->default(0);
            $table->boolean('enable_collections')->default(0);
            $table->String('firebasejson')->nullable();
            $table->String('googleapiurl')->nullable();
            $table->String('m3uplaylistpath')->nullable();
            $table->boolean('m3uplaylist')->default(0);
            $table->boolean('notification_counter')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
